UPDATE `storage_providers` SET 
`handler` = CASE `alias`
    WHEN 'local' THEN 'App\\Http\\Controllers\\Storage\\LocalController'
    WHEN 's3' THEN 'App\\Http\\Controllers\\Storage\\AmazonController'
    WHEN 'digitalocean' THEN 'App\\Http\\Controllers\\Storage\\DigitaloceanController'
    WHEN 'wasabi' THEN 'App\\Http\\Controllers\\Storage\\WasabiController'
    WHEN 'cloudflare' THEN 'App\\Http\\Controllers\\Storage\\CloudflareR2Controller'
    WHEN 'idrive' THEN 'App\\Http\\Controllers\\Storage\\IdriveE2Controller'
    WHEN 'storj' THEN 'App\\Http\\Controllers\\Storage\\StorjController'
    WHEN 'backblaze' THEN 'App\\Http\\Controllers\\Storage\\BackblazeController'
    ELSE `handler`
END
WHERE `alias` IN ('local', 's3', 'digitalocean', 'wasabi', 'cloudflare', 'idrive', 'storj', 'backblaze');
